function amtdisp(msg,flag)
%AMTDISP AMT-specific overload of the function 'disp'
%   Usage: amtdisp(X);
%     amtdisp(X,'progress');
%     amtdisp(X,'volatile');
%
%   AMTDISP(X); can be used to show message X in the command
%   window. The output of AMTDISP depends on the start-up
%   configuration of the AMT. 
%     
%   When the AMT is started in the verbose mode (default mode), AMTDISP 
%   will always display. When the AMT is started in the documentation mode, 
%   AMTDISP will display only if no flag is provided. When the AMT is 
%   started in the silent mode, AMTDISP will never display. See
%   amtstart for further explanation on the start-up configurations. 
%
%   AMTDISP(X,'progress'); can be used as progress indicator. It will be
%   shown during the normal operation but supressed when used to create the
%   documentation.
%
%   AMTDISP(X,'volatile'); can be used as volatile progress indicator.
%   Any subsequent call of the AMTDISP will delete the previous volatile
%   message. This way a changing progress can be clearly shown even in loops. 
% 
%   See also: amtstart
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.9.8/doc/amtdisp.php

% Copyright (C) 2009-2015 Piotr Majdak and Peter L. Søndergaard.
% This file is part of AMToolbox version 0.9.8
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

  
%   Author: Piotr Majdak, 2016
%   last change: 17.5.2017, volatile added

persistent CachedMsg;

if exist('flag','var')
  if ~strcmp(flag,'progress') && ~strcmp(flag,'volatile'),
    error(['Unsupported flag ' flag]);
  end
else
  flag='';
end

flags=amtflags;

if flags.do_verbose
  if strcmp(flag,'volatile')
    if ~isempty(CachedMsg),
      reversemsg = repmat(sprintf('\b'), 1, length(CachedMsg));
      fprintf(reversemsg);
    end
    fprintf(strrep(msg,'\','\\'));
    CachedMsg=msg;
  else
    if ~isempty(CachedMsg),
      reversemsg = repmat(sprintf('\b'), 1, length(CachedMsg));
      fprintf(reversemsg);
      CachedMsg=[];
    end
    disp(msg);
  end
end

if flags.do_documentation
  if ~strcmp(flag,'progress'), 
    disp(msg); 
  end
end

if flags.do_silent
  % do nothing
end
