function data = data_pulkki2001
%DATA_PULKKI2001 Listener-specific panning angles judged best in median
%plane listening test with pink noise
%   Usage: data = data_pulkki2001
%
%   Output parameter:
%     data	: experimental data matrix with dimensions: source angle x listener x trial
%
%   DATA_PULKKI2001 returns listener-specific experimental data
%   from Figure 8 in Pullki (2001; J AES; 49:753-767). Source angle I and II 
%   were at 0 and 15degrees elevation, respectivley. Adjustments were conducted 
%   four times to each source angle and the loudspeaker span was 45 degrees.
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.9.8/doc/data/data_pulkki2001.php

% Copyright (C) 2009-2015 Piotr Majdak and Peter L. Søndergaard.
% This file is part of AMToolbox version 0.9.8
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

data = nan(2,14,4);

data(1,:,:) = [...
  2.84, 4.85, 6.70, 10.90;...
  -1.14, -0.14, 1.87, 3.88;...
  -5.10, -3.10, 1.91, 2.92;...
  -0.22, 0.95, 1.96, 5.65;...
  1.99, 3.99, 4.98, 5.86;...
  0.85, 1.86, 5.86, 8.04;...
  -0.12, 1.89, 6.07, 11.08;...
  5.09, 5.95, 7.95, 10.95;...
  3.98, 6.99, 8.99, 9.84;...
  4.86, 12.88, 16.92, 18.07;...
  4.89, 9.91, 12.08, 11.08;...
  12.80, 13.96, 14.97, 16.66;...
  1.79, 4.80, 6.80, 7.81;...
  1.82, 2.83, 6.85, 8.85];

data(2,:,:) = [...
  15.86, 23.05, 18.01, 21.88;...
	4.85, 13.04, 9.02, 6.84;...
  14.92, 16.93, 18.10, 15.92;...
  12.98, 14.98, 9.96, 17.98;...
  5.97, 7.97, 11.52, 15.71;...
  16.04, 15.03, 18.04, 19.89;...
  18.92, 17.91, 21.77, 25.82;...
  11.93, 10.93, 9.92, 15.79;...
  16.83, 14.81, 21.17, 17.99;...
  17.87, 21.04, 20.03, 23.89;...
  9.04, 11.88, 7.86, 10.87;...
  19.95, 22.96, 18.94, 21.78;...
  12.80, 11.79, 14.80, 16.83;...
  13.84, 15.84, 17.85, 17.70];
