% AMT - General functions used within the AMT
%
%  Signal levels
%     DBSPL            - SPL of signal measured in dB.
%     SETDBSPL         - Specify SPL of signal.
%
%  Emulation of experiments
%     EMUEXP         - Emulate psychoacoustic experiments
%
%  Plotting
%     AUDSPECGRAM      - Auditory spectrogram.
%     MODSPECGRAM      - Temporal modulation spectrogram
%     STMODSPECGRAM    - Spectro-temporal modulation spectrogram
%
%   Filters
%     GAMMATONE        - Calculate Gammatone filter coefficients
%     CQDFT            - FFT-based filter bank with constant relative bandwidth
%     AUDITORYFILTERBANK - Linear auditory filterbank.
%     IHCENVELOPE        - Inner hair cell envelope extration.
%     ADAPTLOOP          - Adaptation loops.
%     DRNL               - Dual resonance non-linear filterbank.
%     MODFILTERBANK      - Modulation filter bank.
%     HEADPHONEFILTER    - FIR filter to model headphones 
%     MIDDLEEARFILTER    - FIR filter to model the middle ear
%     UFILTERBANKZ     - Apply multiple filters
%     FILTERBANKZ      - Apply multiple filters with non-equidistant downsampling
%
%  Various
%     WEIGHTEDAVERAGEFILTER       - Part of the takanen2013 model
%
%  ITD
%     LOCALIZATIONERROR - Calculates various localization errors from localization responses
%     MODFILTERBANKEPSM  - Modulation filter bank (model from Joergensen et al., 2012).
%     EICELL             - Excitation-inhibition cell (model by Breebaart et al., 2001).
%     ITD2ANGLE        - Convert ITD to an angle using a lookup table
%     ITD2ANGLELOOKUPTABLE - Create the lookup table
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.9.8/doc/general/Contents.php

% Copyright (C) 2009-2015 Piotr Majdak and Peter L. Søndergaard.
% This file is part of AMToolbox version 0.9.8
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
