% AMT - Various stages of auditory models
%
%  HRTF processing
%     ZIEGELWANGER2014ONAXIS      - On-axis version of Ziegelwanger et al. (2014)
%     ZIEGELWANGER2014OFFAXIS     - Off-axis version of Ziegelwanger et al. (2014)
%     ZIEGELWANGER2013ONAXIS      - On-axis version of Ziegelwanger et al. (2013) (legacy only)
%     ZIEGELWANGER2013OFFAXIS     - Off-axis version of Ziegelwanger et al. (2013) (legacy only)
%
%  Binaural processing stages
%     LANGENDIJK2002COMP     - Comparison process from Langendijk 20002.
%     LINDEMANN1986BINCORR - Running cross-correlation between two signals.
%     CULLING2005BMLD    - BMLD calculation from Culling et al. (2005).
%     DIETZ2011UNWRAPITD - IPD to ITD transformation for the Dietz model
%     DIETZ2011FILTERBANK - filterbank of Dietz 2011 binaural model
%     DIETZ2011INTERAURALFUNCTIONS - Calculate interaural parameters for Dietz 2011 model
%     WIERSTORF2013ESTIMATEAZIMUTH - Azimuth position estimation based on dietz2011 or lindemann1986
%     ZIEGELWANGER2014OFFAXIS - synthesis of TOAs for the off-axis model
%     ZIEGELWANGER2014ONAXIS  - synthesis of TOAs for the on-axis model
%     LANGENDIJK2002LIKELIHOOD - Likelihood estimation
%
%  
%   Modulation detection and masking stages
%     DAU1996PREPROC - signal detection model from Dau et al. (1996)
%     DAU1997PREPROC - modulation-detection and modulation-masking processing from Dau et al. (1997)
%     JEPSEN2008PREPROC - intensity discrimination, tone-in-noise detection, spectral masking, forward masking, and amplitude-modulation detection from Jepsen et al. (2008)
%
%     LINDEMANN1986CENTROID - Centroid of the cross-correlation activation
%
%     ROENNE2012CHIRP          - Simulate chirp evoked ABRs
%     ROENNE2012CLICK          - Simulate ABR respone to click
%     ROENNE2012TONEBURSTS     - Simulate tone burst evoked ABR wave V latencies
%
%   Gammatone filterbank framework from Hohmann (2002)
%     HOHMANN2002DELAY            - Create a delay object
%     HOHMANN2002MIXER            - Create a mixer object
%     HOHMANN2002SYNTH            - Create a synthesis object 
%     HOHMANN2002FILTER           - Create a single Gammatone filter object
%     HOHMANN2002PROCESS          - Process the input signals by the corresponding filterbank object
%     HOHMANN2002CLEARSTATE       - Clears the state of the filterbank object
%     HOHMANN2002FREQZ            - Calculates frequency response of a filterbank object
%     HOHMANN2002CLEARSTATE       - Clears the state of the filterbank objects
%     HOHMANN2002FREQZ            - Calculates frequency response of a filterbank object
%
%  The Takanen 2013 model   - Takanen 2013 binaural auditory model
%     TAKANEN2013CONTRACOMPARISON - Enhance contrast between hemispheres
%     TAKANEN2013CUECONSISTENCY - Check consistency before cue combination
%     TAKANEN2013DIRECTIONMAPPING - Map the directional cues to directions
%     TAKANEN2013FORMBINAURALACTIVITYMAP - Steer cues on a topographic map
%     TAKANEN2013LSO        - Model of the lateral superior olive
%     TAKANEN2013MSO        - Model of the medial superior olive
%     TAKANEN2013ONSETENHANCEMENT - Emphasize onsets on direction analysis
%     TAKANEN2013PERIPHERY  - Process input through the model of periphery
%     TAKANEN2013WBMSO      - Wideband medial superior olive model
%
%  Binaural masking level differences from Breebaart et al. (2001)
%     BREEBAART2001PREPROC  - Preprocessor of a binaural signal with EI-cell output
%     BREEBAART2001CENTRALPROC - Central processor taking decision in an experiment
%     BREEBAART2001OUTMIDDLEFILTER - Outer and middle-ear filter used by the model Breebaart et al. (2001)
% 
%
%  Sagittal-plane localization models
%     BAUMGARTNER2013PMV2PPP - Calculate performance predictions from PMVs for baumgartner2013
%     BAUMGARTNER2014SPECTRALANALYSIS - Approximation of spectral analysis by auditory periphery
%     BAUMGARTNER2014GRADIENTEXTRACTION - Extraction of positive spectral gradients
%     BAUMGARTNER2014COMPARISONPROCESS - Comparison with direction-specific templates
%     BAUMGARTNER2014SIMILARITYESTIMATION - Similarity estimation with listener-specific sensitivity
%     BAUMGARTNER2014BINAURALWEIGHTING - Binaural combination of monaural similarity estimates
%     BAUMGARTNER2014SENSORIMOTORMAPPING - Response scatter induced by localization task
%     BAUMGARTNER2014CALIBRATION - Calibration of the model (linear periphery)
%     BAUMGARTNER2014VIRTUALEXP - Performs a virtual sound-localization experiment
%     BAUMGARTNER2014PMV2PPP - Performance predictions from PMVs of baumgartner2014
%     BAUMGARTNER2014LIKELISTAT - Likelihood statistics for evaluation of model performance
%     BAUMGARTNER2016CALIBRATION - Calibration of the model (nonlinear periphery)
%     BAUMGARTNER2016SPECTRALANALYSIS - Approximation of spectral analysis by auditory periphery
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.9.8/doc/modelstages/Contents.php

% Copyright (C) 2009-2015 Piotr Majdak and Peter L. Søndergaard.
% This file is part of AMToolbox version 0.9.8
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
