function obj = hohmann2002clearstate(obj)
%HOHMANN2002CLEARSTATE  Reset states of hohmann2002 filters
%   Usage: filter = hohmann2002clearstate(filter)
%          fb = hohmann2002clearstate(fb)
%
%   filter = HOHMANN2002CLEARSTATE(filter) resets the states of the
%   filter created by HOHMANN2002FILTER
%
%   fb = HOHMANN2002CLEARSTATE(fb) resets the states of the
%   filterbank fb created by HOHMANN2002
% 
%   delay = HOHMANN2002CLEARSTATE(delay) resets the states of the
%   delay created by HOHMANN2002DELAY
%
%   synth = HOHMANN2002CLEARSTATE(synth) resets the states of the
%   sinthesis filterbank created by HOHMANN2002SYNTH
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.9.8/doc/modelstages/hohmann2002clearstate.php

% Copyright (C) 2009-2015 Piotr Majdak and Peter L. Søndergaard.
% This file is part of AMToolbox version 0.9.8
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
% Original author: Universitaet Oldenburg, tp (Jan 2002, Nov 2006, Feb 2007)
% Adapted to AMT (PM, Jan 2016) from functions gfb_*_clear_state

if ~isfield(obj,'type'), error('Type of the object missing'); end
switch(obj.type)
  case 'gfb_Filter'
    obj.state = zeros(1, obj.gamma_order);
  case 'gfb_analyzer'
    for band = 1:length(obj.center_frequencies_hz)
        obj.filters(1, band).state = zeros(1, obj.filters(1, band).gamma_order);
    end
  case 'gfb_Delay'
    obj.memory = zeros(size(obj.memory));
  case 'gfb_Synthesizer'
    obj.delay.memory = zeros(size(obj.delay.memory));
  otherwise
    error('Unknown type of HOHMANN2002 filter object');    
end

